//
//  MCAuthScript.h
//  MCFoundation
//
//  Created by Ali Lalani on 23/03/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCAuthScript : NSObject {

}

+ (OSStatus)authorizeRootWithPrompt:(NSString *)promptStr;
+ (OSStatus)authorizeRoot;
+ (BOOL)isRootAuthorized;
+ (void)closeAuthorizeRoot;

+ (OSStatus)runCommand:(NSString *)command arguments:(NSArray *)args output:(NSString **)someOutput;


#pragma mark Utilities
+ (OSStatus)copyPath:(NSString *)path1 toPath:(NSString  *)path2 recursively:(BOOL)recursive output:(NSString **)someOutput;
+ (OSStatus)removeFileAtPath:(NSString *)file output:(NSString **)someOutput;
+ (OSStatus)removeFolderAtPath:(NSString *)file output:(NSString **)someOutput;
+ (OSStatus)moveFileAtPath:(NSString *)file toFolder:(NSString *)folder output:(NSString **)someOutput;

+ (OSStatus)chownFileAtPath:(NSString *)path ownership:(NSString *)ownershipStr recursively:(BOOL)recursive output:(NSString **)someOutput;
+ (OSStatus)chmodFileAtPath:(NSString *)path mode:(NSString *)mode recursively:(BOOL)recursive output:(NSString **)someOutput;
+ (OSStatus)createFolder:(NSString *)path output:(NSString *)someOutput;
@end
